//+------------------------------------------------------------------+
//|                                                        Setka.mq5 |
//|                                          Copyright Privalov S.V. |
//|                           https://login.mql5.com/ru/users/Prival |
//+------------------------------------------------------------------+
#property copyright "Privalov S.V."
#property link      "https://login.mql5.com/ru/users/Prival"
#property version   "3.02"
#property indicator_chart_window

//--- input parameters
input int   Step=250;         // vertical grid step in points
input int   Figure=1000;      // figure step

                              // color of vertical lines
color new_hour=DimGray;       // new hour
color new_day =Blue;          // new day
color new_week=DeepPink;      // new week
color new_mon =Yellow;        // new month

                              // color horizontal lines
color new_Hfigure=RoyalBlue;  // new figure
color new_Hline=DimGray;      // new line

                              //
double minChartPrice,minChartPrice_old;
double maxChartPrice,maxChartPrice_old;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   EventSetTimer(25);
//---
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
   EventKillTimer();
   ObjectsDeleteAll(0,0,OBJ_HLINE);   // removing all horizontal lines
   ObjectsDeleteAll(0,0,OBJ_VLINE);   // removing all vertical lines
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate (const int rates_total,      // rates total
                 const int prev_calculated,  // processed at last call
                 const datetime& time[],     // Time
                 const double& open[],       // Open
                 const double& high[],       // High
                 const double& low[],        // Low
                 const double& close[],      // Close
                 const long& tick_volume[],  // Tick Volume
                 const long& volume[],       // Real Volume
                 const int& spread[])        // Spread
  {
//---
   if(rates_total<0) return(0);  // don't calculate/plot anything

   ArraySetAsSeries(time,true);
   MqlDateTime str;
   color  ColorLine;

// **************** vertical lines ************************************************
   string name_line="";     // name
   int    start,            // starting point
   counter_line,     // line counter
   kol_Bars,         // number of visible bars
   kol_Bars_old;     // old number of visible bars

   kol_Bars=(int)ChartGetInteger(0,CHART_FIRST_VISIBLE_BAR);

   if(prev_calculated==0 || kol_Bars>kol_Bars_old) 
     {
      start=kol_Bars-1;                    // starting index for a plot = kol_Bars
      kol_Bars_old=kol_Bars;               // save it
      ObjectsDeleteAll(0,0,OBJ_VLINE);     // deleting all vertical lines
                                           // set the line for the closest hour
      if(_Period<PERIOD_M30) 
        {
         TimeToStruct(TimeCurrent(),str);
         if(ObjectFind(0,"VLine_0")<0) SetVLine("VLine_0",TimeCurrent()+60*(60-str.min)+(60-str.sec),new_hour);
        }
     }
   else start=rates_total-prev_calculated;

   for(int i=start;i>0;i--) 
     {
      ColorLine=0;
      if(isNewBar_i(time[i],PERIOD_H1) && (_Period<PERIOD_M30)) ColorLine=new_hour;
      if(isNewBar_i(time[i],PERIOD_D1) && (_Period<PERIOD_H4 )) ColorLine=new_day;
      if(isNewBar_i(time[i],PERIOD_W1) && (_Period<PERIOD_D1 )) ColorLine=new_week;
      if(isNewBar_i(time[i],PERIOD_MN1)&& (_Period<PERIOD_MN1)) ColorLine=new_mon;
      if(ColorLine!=0) 
        {
         // formation of name for 12:00 line
         counter_line++;
         TimeToStruct(time[i],str);
         StringConcatenate(name_line,IntegerToString(str.hour,2,'0'),":",IntegerToString(str.min,2,'0'),"_N",counter_line);
         // setting the line
         SetVLine(name_line,time[i],ColorLine);
        } // end if(ColorLine!=0) 
     }// end for(int i=start;i>=0;i--)
//--- return value of prev_calculated for next call
   return(rates_total);
  }
//+----------------------------------------------------------------------------+
//|  Description : Set the OBJ_VLINE vertical line                             |
//+----------------------------------------------------------------------------+
//|  Parameters:                                                               |
//|    nm - line name                                                          |
//|    t1 - line time                                                          |
//|    cl - line color                                                         |
//+----------------------------------------------------------------------------+
void SetVLine(string nm="",datetime t1=0,color cl=Red)
  {
   ResetLastError();
   if(t1<=0) return;
   if(ObjectFind(0,nm)<0) ObjectCreate(0,nm,OBJ_VLINE,0,t1,2);
   else Print("Error LastError=",_LastError," in creation of line: SetVLine ",nm," t=",t1);

   ObjectSetInteger(0,nm,OBJPROP_COLOR,cl);
   ObjectSetInteger(0,nm,OBJPROP_STYLE,STYLE_DOT);
   ObjectSetInteger(0, nm, OBJPROP_WIDTH, 1);          // line width
   ObjectSetInteger(0, nm, OBJPROP_BACK,  true);       // as background
   ObjectSetInteger(0, nm, OBJPROP_SELECTABLE, false); // disable line selection
  }
//+----------------------------------------------------------------------------+
//|  Description : Set the OBJ_HLINE horizontal line                           |
//+----------------------------------------------------------------------------+
//|  Parameters:                                                               |
//|    nm - line name                                                          |
//|    p1 - price                                                              |
//|    cl - line color                                                         |
//+----------------------------------------------------------------------------+
void SetHLine(string nm="",double p1=0,color cl=Red)
  {
   ResetLastError();
   if(ObjectFind(0,nm)<0) ObjectCreate(0,nm,OBJ_HLINE,0,0,p1);
   else Print(" LastError=",_LastError,"  SetHLine ",nm," p1=",p1);

   ObjectSetInteger(0, nm, OBJPROP_COLOR, cl);         // color  
   ObjectSetInteger(0, nm, OBJPROP_STYLE, STYLE_DOT);  // style
   ObjectSetInteger(0, nm, OBJPROP_WIDTH, 1);          // width
   ObjectSetInteger(0, nm, OBJPROP_SELECTABLE, false); // disable line selection
  }
//+----------------------------------------------------------------------------+
//|  Description : Horizontal lines setting                                    |
//+----------------------------------------------------------------------------+
void Ris_H_Line(double max,double min)
  {
   double Uroven=0.0;      // level of first horizontal line
   int    rez,             // is it figure or not
   counter_line=0,  // lines counter
   i=0;             // passes counter

   while(Uroven<=max)
     {
      i++;
      Uroven=i*Step*_Point;
      if(Uroven>=min) 
        {
         counter_line++;
         rez=(int)MathMod(Uroven*MathPow(10,_Digits),Figure); //   
         if(rez==0) 
           {
            // show figure up to W1
            if(_Period<PERIOD_W1) SetHLine("HLine_"+counter_line,Uroven,new_Hfigure);
           }
         else
         // show the intermediate level up to M30 
            if(_Period<PERIOD_M30) SetHLine("HLine_"+counter_line,Uroven,new_Hline);
        }// end if(Uroven>=Min)
     }// end while (Uroven<=Max)
  }//end of Horizontal lines setting function
//+------------------------------------------------------------------+
//| Returns true if a new bar, overwise returns false                |
//+------------------------------------------------------------------+
bool isNewBar_i(datetime date,ENUM_TIMEFRAMES timeFrame)
  {
//----
   static datetime old_Times[21];// array for serving the old time values
   bool res=false;               // variable for the result
   int  pos;                     // index of old_Times[]     
   datetime new_Time[1];         // new bar time

   switch(timeFrame)
     {
      case PERIOD_M1:  pos= 0; break;
      case PERIOD_M2:  pos= 1; break;
      case PERIOD_M3:  pos= 2; break;
      case PERIOD_M4:  pos= 3; break;
      case PERIOD_M5:  pos= 4; break;
      case PERIOD_M6:  pos= 5; break;
      case PERIOD_M10: pos= 6; break;
      case PERIOD_M12: pos= 7; break;
      case PERIOD_M15: pos= 8; break;
      case PERIOD_M20: pos= 9; break;
      case PERIOD_M30: pos=10; break;
      case PERIOD_H1:  pos=11; break;
      case PERIOD_H2:  pos=12; break;
      case PERIOD_H3:  pos=13; break;
      case PERIOD_H4:  pos=14; break;
      case PERIOD_H6:  pos=15; break;
      case PERIOD_H8:  pos=16; break;
      case PERIOD_H12: pos=17; break;
      case PERIOD_D1:  pos=18; break;
      case PERIOD_W1:  pos=19; break;
      case PERIOD_MN1: pos=20; break;
     }
// copying the time of a bar to the new_Time[0]   
   int copied=CopyTime(_Symbol,timeFrame,date,1,new_Time);

   if(copied>0) // all ok, data has been copied
     {
      if(old_Times[pos]!=new_Time[0]) // if old bar time isn't equal to new
        {
         if(old_Times[pos]!=0) res=true;    // if it isn't the first call, the result (new bar) is true
         old_Times[pos]=new_Time[0];        // saving the bar time
        }
     }
//---- 
   return(res);
  }
//+------------------------------------------------------------------+
//| Vertical resize                                                  |
//+------------------------------------------------------------------+
void OnChartEvent(const int          id,
                  const long    &lparam,
                  const double  &dparam,
                  const string  &sparam)
  {
// draw the horizontal lines if the window size has increased
   minChartPrice=NormalizeDouble(ChartGetDouble(ChartID(),CHART_PRICE_MIN,0),_Digits);
   maxChartPrice=NormalizeDouble(ChartGetDouble(ChartID(),CHART_PRICE_MAX,0),_Digits);

   if(minChartPrice<minChartPrice_old || maxChartPrice>maxChartPrice_old) 
     {

      minChartPrice_old=minChartPrice-Step*_Point;       // saving the sizes +- step
      maxChartPrice_old=maxChartPrice+Step*_Point;       // 
      ObjectsDeleteAll(0,0,OBJ_HLINE);                   // delete all horizontal lines
      Ris_H_Line(maxChartPrice_old, minChartPrice_old);  // draw
      ChartRedraw();
     }
   return;
  }
//+------------------------------------------------------------------+
//| Timer                                                            |
//+------------------------------------------------------------------+
void OnTimer()
  {
// we will use the time because of possible connection problems
   if(_Period<PERIOD_M30) 
     {
      MqlDateTime str;
      // delete old line of the closest hour
      if(ObjectFind(0,"VLine_0")>=0) ObjectDelete(0,"VLine_0");
      // set new line of the closest hour
      TimeToStruct(TimeCurrent(),str);
      if(ObjectFind(0,"VLine_0")<0) SetVLine("VLine_0",TimeCurrent()+60*(60-str.min)+(60-str.sec),new_hour);
     } // end if(_Period<PERIOD_M30)

// protection of uncontrolled data reloading
// if we don't do it, the function isNewBar_i will not be able to work after some time
   datetime var[2];
   CopyTime(_Symbol,PERIOD_M5,0,2,var);
   CopyTime(_Symbol,PERIOD_M15,0,2,var);
   CopyTime(_Symbol,PERIOD_M30,0,2,var);
   CopyTime(_Symbol,PERIOD_H1,0,2,var);
   CopyTime(_Symbol,PERIOD_H4,0,2,var);
   CopyTime(_Symbol,PERIOD_D1,0,2,var);
   CopyTime(_Symbol,PERIOD_W1,0,2,var);
   CopyTime(_Symbol,PERIOD_MN1,0,2,var);
   return;
  }
//+------------------------------------------------------------------+
