//+------------------------------------------------------------------+
//|                                                   StepSto_v2.mq5 |
//|                           Copyright  2005, TrendLaboratory Ltd. |
//|            http://finance.groups.yahoo.com/group/TrendLaboratory |
//|                                       E-mail: igorad2004@list.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, TrendLaboratory Ltd."
#property link      "http://finance.groups.yahoo.com/group/TrendLaboratory"
//----   
#property version   "1.00"
//----     
#property indicator_separate_window
//----        
#property indicator_buffers 3
//----    
#property indicator_plots   2
//+----------------------------------------------+
//|     StepSto Fast |
//+----------------------------------------------+
//----      
#property indicator_type1 DRAW_COLOR_HISTOGRAM
//----     
#property indicator_color1 clrLime,clrGreen,clrGray,clrMaroon,clrRed
//----   - 
#property indicator_style1 STYLE_SOLID
//----     2
#property indicator_width1 2
//----    
#property indicator_label1  "StepSto Fast"
//+----------------------------------------------+
//|     StepSto Slow |
//+----------------------------------------------+
//----   2   
#property indicator_type2   DRAW_LINE
//----        MediumSlateBlue 
#property indicator_color2  clrMediumSlateBlue
//----   2 -  
#property indicator_style2  STYLE_SOLID
//----    2  1
#property indicator_width2  1
//----    
#property indicator_label2  "StepSto Slow"
//+----------------------------------------------+
//|                            |
//+----------------------------------------------+
#define RESET  0 //        
//+----------------------------------------------+
//|                    |
//+----------------------------------------------+
input double Kfast=1.0000;
input double Kslow=1.0000;
input int Shift=0;             //      
//+----------------------------------------------+
//----   ,         
double FastBuffer[],ColorFastBuffer[];
double SlowBuffer[];
//----      
int ATR_Handle;
//----      
int min_rates_total,PeriodATR;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+  
void OnInit()
  {
//----     
   PeriodATR=10;
   min_rates_total=MathMax(2,PeriodATR);

//----    iATR
   ATR_Handle=iATR(NULL,PERIOD_CURRENT,PeriodATR);
   if(ATR_Handle==INVALID_HANDLE) Print("      iATR");

//----      
   SetIndexBuffer(0,FastBuffer,INDICATOR_DATA);
//----    1    Shift
   PlotIndexSetInteger(0,PLOT_SHIFT,Shift);
//----       1  min_rates_total
   PlotIndexSetInteger(0,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(FastBuffer,true);
//----     ,     
   SetIndexBuffer(1,ColorFastBuffer,INDICATOR_COLOR_INDEX);
//----       
   ArraySetAsSeries(ColorFastBuffer,true);

//----      
   SetIndexBuffer(2,SlowBuffer,INDICATOR_DATA);
//----    2    Shift
   PlotIndexSetInteger(1,PLOT_SHIFT,Shift);
//----       2  min_rates_total
   PlotIndexSetInteger(1,PLOT_DRAW_BEGIN,min_rates_total);
//----       
   ArraySetAsSeries(SlowBuffer,true);

//----      
   string shortname;
   StringConcatenate(shortname,"StepSto(",Kfast,",",Kslow,")");
//---           
   IndicatorSetString(INDICATOR_SHORTNAME,shortname);
//---     
   IndicatorSetInteger(INDICATOR_DIGITS,0);
//----
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(
                const int rates_total,    //       
                const int prev_calculated,//       
                const datetime &time[],
                const double &open[],
                const double& high[],     //       
                const double& low[],      //        
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[]
                )
  {
//----       
   if(BarsCalculated(ATR_Handle)<rates_total || rates_total<min_rates_total) return(RESET);

//----    
   int limit,to_copy,TrendMin0,TrendMax0,TrendMid0,clr;
   double ATR[],linemin=0.0,linemax=0.0,linemid=0.0,Sto1,Sto2,bsmin,bsmax,StepSizeMin,StepSizeMax;
   double SminMid0,SmaxMid0,SminMin0,SmaxMin0,SminMax0,SmaxMax0,ATRmax0,ATRmin0,StepSizeMid;
   static double SminMin1,SmaxMin1,SminMax1,SmaxMax1,SminMid1,SmaxMid1,ATRmax1,ATRmin1;
   static int TrendMin1,TrendMax1,TrendMid1;

//----    ,     
   ArraySetAsSeries(close,true);
   ArraySetAsSeries(ATR,true);

//----    limit    
   if(prev_calculated>rates_total || prev_calculated<=0)//      
     {
      limit=rates_total-min_rates_total-1; //      
      ATRmax1=0.0;
      ATRmin1=999999999.9;
      SminMin1=close[limit];
      SmaxMin1=close[limit];
      SminMax1=close[limit];
      SmaxMax1=close[limit];
      SminMid1=close[limit];
      SmaxMid1=close[limit];
      TrendMax1=+1;
      TrendMin1=-1;
      TrendMid1=+1;
     }
   else limit=rates_total-prev_calculated; //      
//----
   to_copy=limit+1;

//----      
   if(CopyBuffer(ATR_Handle,0,0,to_copy,ATR)<=0) return(RESET);

//----   
   TrendMax0=TrendMax1;
   TrendMin0=TrendMin1;
   TrendMid0=TrendMid1;

//----    
   for(int bar=limit; bar>=0 && !IsStopped(); bar--)
     {
      ATRmax0=MathMax(ATR[bar],ATRmax1);
      ATRmin0=MathMin(ATR[bar],ATRmin1);
      //----
      StepSizeMin=(Kfast*ATRmin0);
      StepSizeMax=(Kfast*ATRmax0);
      StepSizeMid=Kfast*0.5*Kslow*(ATRmax0+ATRmin0);
      //----
      SmaxMin0=close[bar]+2*StepSizeMin;
      SminMin0=close[bar]-2*StepSizeMin;

      SmaxMax0=close[bar]+2*StepSizeMax;
      SminMax0=close[bar]-2*StepSizeMax;

      SmaxMid0=close[bar]+2*StepSizeMid;
      SminMid0=close[bar]-2*StepSizeMid;
      //----
      if(close[bar]>SmaxMin1) TrendMin0=+1;
      if(close[bar]<SminMin1) TrendMin0=-1;

      if(close[bar]>SmaxMax1) TrendMax0=+1;
      if(close[bar]<SminMax1) TrendMax0=-1;

      if(close[bar]>SmaxMid1) TrendMid0=+1;
      if(close[bar]<SminMid1) TrendMid0=-1;

      if(TrendMin0>0 && SminMin0<SminMin1) SminMin0=SminMin1;
      if(TrendMin0<0 && SmaxMin0>SmaxMin1) SmaxMin0=SmaxMin1;

      if(TrendMax0>0 && SminMax0<SminMax1) SminMax0=SminMax1;
      if(TrendMax0<0 && SmaxMax0>SmaxMax1) SmaxMax0=SmaxMax1;

      if(TrendMid0>0 && SminMid0<SminMid1) SminMid0=SminMid1;
      if(TrendMid0<0 && SmaxMid0>SmaxMid1) SmaxMid0=SmaxMid1;

      if(TrendMin0>0) linemin=SminMin0+StepSizeMin;
      if(TrendMin0<0) linemin=SmaxMin0-StepSizeMin;

      if(TrendMax0>0) linemax=SminMax0+StepSizeMax;
      if(TrendMax0<0) linemax=SmaxMax0-StepSizeMax;

      if(TrendMid0>0) linemid=SminMid0+StepSizeMid;
      if(TrendMid0<0) linemid=SmaxMid0-StepSizeMid;
      //----      
      bsmin=linemax-StepSizeMax;
      bsmax=linemax+StepSizeMax;

      Sto1=100*(linemin-bsmin)/(bsmax-bsmin);
      Sto2=100*(linemid-bsmin)/(bsmax-bsmin);
      Sto1-=50;
      Sto2-=50;
      FastBuffer[bar]=Sto1;
      SlowBuffer[bar]=Sto2;
      clr=2;

      if(Sto1>0)
        {
         if(Sto1>=Sto2) clr=0;
         else clr=1;
        }
      else
        {
         if(Sto1<=Sto2) clr=4;
         else clr=3;
        }
      ColorFastBuffer[bar]=clr;

      if(bar)
        {
         ATRmax1=ATRmax0;
         ATRmin1=ATRmin0;
         SminMin1=SminMin0;
         SmaxMin1=SmaxMin0;
         SminMax1=SminMax0;
         SmaxMax1=SmaxMax0;
         SminMid1=SminMid0;
         SmaxMid1=SmaxMid0;
         TrendMax1=TrendMax0;
         TrendMin1=TrendMin0;
         TrendMid1=TrendMid0;
        }
     }
//----     
   return(rates_total);
  }
//+------------------------------------------------------------------+
